
function load {
    kill @e[tag=shader_trigger]
    kill @e[tag=shader_disable]
    kill @e[tag=ui]
    # say Loaded utility functions
    scoreboard objectives add ak.debug dummy
    scoreboard players set bonnie ak.debug 0
    kill @e[tag=animatronic]
    execute positioned -23 -60 195 run function util:reset_camera_state

    execute as @a at @s positioned ^ ^ ^ run {
        function util:office_camera_off_internal
        function util:reset_office_camera
        function util:reset_video_camera
    }
    sequence {
        LOOP(30,i) {
            execute as @a at @s run function util:disable_shader
            delay 1t
        }
    }
    gamerule doFireTick false
    gamerule fireDamage false
    kill @e[type=text_display,tag=cut_feed]
}

function to_lobby {
    tag @a add crosshair
    scoreboard players set manual_reload ak.state 1
    schedule 2t replace {
        reload
    }

    schedule 4t replace {
        scoreboard players set manual_reload ak.state 0
        execute positioned as @e[tag=lobby_spawn,limit=1] rotated 180 0 run tp @a ~ ~ ~ ~ ~
        execute as @p at @s run function util:disable_shader
    }
}

function transition {
    title @a title {"text":"T","font":"cursor"}
    schedule 8t replace {
        title @a title ""
    }
}

function convert_to_display_entity {
    execute as @e[type=minecraft:armor_stand] at @s anchored eyes run {
        summon minecraft:item_display ^ ^-0.09 ^ {Tags:["new"], item_display: "head"}

        data modify entity @e[type=item_display, tag=new, limit=1] item set from entity @s ArmorItems[3]
        data modify entity @e[type=item_display, tag=new, limit=1] Rotation set from entity @s Rotation
        data modify entity @e[type=item_display, tag=new, limit=1] transformation.scale set value [0.625, 0.625, 0.625]
        data modify entity @e[type=item_display, tag=new, limit=1] Tags set from entity @s Tags

        tag @e[type=item_display] remove new

        kill @s
    }
}

function tick {
    execute unless score gamemode save matches 2 run item replace entity @a[tag=!debug] weapon.mainhand with diamond{display:{Name:'{"text":" "}'}} 1
    effect give @a[tag=nvg] minecraft:night_vision infinite 100 true

    execute if score cut_feed_timer ak.state matches 1.. run {
        scoreboard players remove cut_feed_timer ak.state 1
        execute unless entity @e[type=text_display,tag=cut_feed] at @a run summon text_display ~ ~ ~ {Tags:["cut_feed"],text:'{"text":"C","font":"cursor"}'}
    }

    execute if score cut_feed_timer ak.state matches 1.. unless score inside_camera office_info matches 1 run {
        kill @e[type=text_display,tag=cut_feed]
    }

    execute if score cut_feed_timer ak.state matches ..0 if score cut_feed ak.state matches 1 run {
        scoreboard players set cut_feed ak.state 0
        kill @e[type=text_display,tag=cut_feed]
        scoreboard players set camera_state jc.temp 0
    }

    execute if score vid_camera ak.state matches 100 run {
        ## Disabled camera is selected
        execute unless entity @e[tag=cam6_feed] run summon text_display -33.0 -57.0 202.5 {Tags:["cam6_feed"],text:'{"text":"C","font":"cursor"}'}
    }
    execute unless score vid_camera ak.state matches 100 run {
        kill @e[tag=cam6_feed]
    }
}

function reset_video_camera {
    function util:reset_camera_state
    scoreboard players set vid_camera ak.state -2
    function util:set_video_camera_state_internal
    scoreboard players set inside_camera office_info 0
    function util:update_ui_state
}

function set_video_camera_state {
    function util:reset_camera_state
    tag @s remove active_office_camera
    title @s actionbar ""
    scoreboard players set inside_camera office_info 1
    scoreboard players operation vid_camera ak.state = selected_camera office_info
    
    schedule 2t replace {
        execute as @p at @s run function util:set_video_camera_state_internal
        execute as @p at @s run function util:update_ui_state
        execute as @p at @s run function util:set_cam_interact
    }
}

function set_cam_interact {
    execute anchored eyes run tp @e[type=interaction,tag=cam_interact] ^ ^-0.5 ^
}

function update_ui_state {
    execute if score compatibility ui matches 1 run function ui:update
    execute if score compatibility ui matches 1 run return 1

    ### 
    # markerPixel.g * 255 == 1 -> power
    # markerPixel.g * 255 == 2 -> usage
    # markerPixel.g * 255 == 3 -> time
    # markerPixel.g * 255 == 4 -> night
    # markerPixel.g * 255 == 5 -> camera
    ###

    sequence {
        delay 3t
        kill @e[tag=ui]
        execute as @p at @s anchored eyes positioned ^ ^ ^ run function util:update_inside_camera_ui
        delay 3t
        kill @e[tag=ui]
        execute as @p at @s anchored eyes positioned ^ ^ ^ run function util:update_power_ui
        delay 3t
        kill @e[tag=ui]
        execute as @p at @s anchored eyes positioned ^ ^ ^ run function util:update_usage_ui
        delay 3t
        kill @e[tag=ui]
        execute as @p at @s anchored eyes positioned ^ ^ ^ run function util:update_inside_camera_ui
        delay 3t
        kill @e[tag=ui]
        execute as @p at @s anchored eyes positioned ^ ^ ^ run function util:update_night_ui
        delay 3t
        kill @e[tag=ui]
        execute as @p at @s anchored eyes positioned ^ ^ ^ run function util:update_time_ui
        delay 3t
        kill @e[tag=ui]
        execute as @p at @s anchored eyes positioned ^ ^ ^ run function util:update_selected_camera_ui
        delay 3t
        kill @e[tag=ui]
        delay 3t
        execute as @p at @s anchored eyes positioned ^ ^ ^ run function util:update_inside_camera_ui
        delay 3t
        kill @e[tag=ui]
    }
}

function update_power_ui {
    execute if score compatibility ui matches 1 run function ui:update
    execute if score compatibility ui matches 1 run return 1
    LOOP(100,i){
        execute if score power office_info matches <%i%> run summon item_display ~ ~ ~ {Tags:["ui"],item:{id:"minecraft:leather_horse_armor",Count:1b,tag:{display:{color:<%16711936 + i%>}}}}
    }
}

function update_usage_ui {
    execute if score compatibility ui matches 1 run function ui:update
    execute if score compatibility ui matches 1 run return 1
    LOOP(4,i) {
        execute if score usage office_info matches <%i%> run summon item_display ~ ~ ~ {Tags:["ui"],item:{id:"minecraft:leather_horse_armor",Count:1b,tag:{display:{color:<%16712192 + i%>}}}}
    }
}

function update_time_ui {
    execute if score compatibility ui matches 1 run function ui:update
    execute if score compatibility ui matches 1 run return 1
    LOOP(7,i) {
        execute if score hour office_info matches <%i%> run summon item_display ~ ~ ~ {Tags:["ui"],item:{id:"minecraft:leather_horse_armor",Count:1b,tag:{display:{color:<%16712448 + i%>}}}}
    }
}

function update_night_ui {
    execute if score compatibility ui matches 1 run function ui:update
    execute if score compatibility ui matches 1 run return 1
    LOOP(10,i) {
        execute if score night office_info matches <%i%> run summon item_display ~ ~ ~ {Tags:["ui"],item:{id:"minecraft:leather_horse_armor",Count:1b,tag:{display:{color:<%16712704 + i%>}}}}
    } 
}

function update_selected_camera_ui {
    execute if score compatibility ui matches 1 run function ui:update
    execute if score compatibility ui matches 1 run return 1
    LOOP(9,i) {
        execute if score selected_camera office_info matches <%i%> run summon item_display ~ ~ ~ {Tags:["ui"],item:{id:"minecraft:leather_horse_armor",Count:1b,tag:{display:{color:<%16712960 + i%>}}}}
    }
    execute if score selected_camera office_info matches 9 run summon item_display ~ ~ ~ {Tags:["ui"],item:{id:"minecraft:leather_horse_armor",Count:1b,tag:{display:{color:<%16712960 + 10%>}}}}
    execute if score selected_camera office_info matches 100 run summon item_display ~ ~ ~ {Tags:["ui"],item:{id:"minecraft:leather_horse_armor",Count:1b,tag:{display:{color:<%16712960 + 9%>}}}}
}

function update_inside_camera_ui {
    execute if score compatibility ui matches 1 run function ui:update
    execute if score compatibility ui matches 1 run return 1
    execute if score inside_camera office_info matches 1 run summon item_display ~ ~ ~ {Tags:["ui"],item:{id:"minecraft:leather_horse_armor",Count:1b,tag:{display:{color:16744447}}}}
    execute unless score inside_camera office_info matches 1 run summon item_display ~ ~ ~ {Tags:["ui"],item:{id:"minecraft:leather_horse_armor",Count:1b,tag:{display:{color:16744192}}}}
}

function disable_shader_old {
    summon creeper ~ ~ ~ {NoAI:1b, Silent:1b}
    gamemode spectator @s
    spectate @e[type=creeper,distance=..2,limit=1,sort=nearest] @s
    gamemode adventure @p
    tp @e[type=creeper,distance=..2,limit=1,sort=nearest] ~ ~-1000 ~
}

function disable_shader {
    bossbar set minecraft:main visible false
    execute at @a run summon item_display ~ ~ ~ {Tags:["shader_disable"],item:{id:"minecraft:leather_horse_armor",Count:1b,tag:{display:{color:16744704}}}}
    schedule 4t replace {
        kill @e[tag=shader_disable]
    }
}

function trigger_shader_old {
    summon creeper ~ ~ ~ {NoAI:1b, Silent:1b}
    gamemode spectator @s
    spectate @e[type=creeper,distance=..2,limit=1,sort=nearest] @s
    spawnpoint @s ~ ~ ~ ~
    kill @s
    tp @e[type=creeper,distance=..2,limit=1,sort=nearest] ~ ~-1000 ~

    schedule 2t replace {
        gamemode adventure @p
    }
}

function trigger_shader {
    execute if score compatibility ui matches 1 run bossbar set minecraft:main visible true
    execute if score compatibility ui matches 1 run return 1
    sequence {
        LOOP(30,i) {
            execute as @a at @s run function util:trigger_shader_internal
            delay 1t
        }
    }
    
}

function trigger_shader_internal {
    execute at @a run summon item_display ~ ~ ~ {Tags:["shader_trigger"],item:{id:"minecraft:leather_horse_armor",Count:1b,tag:{display:{color:16744448}}}}
    schedule 4t replace {
        kill @e[tag=shader_trigger]
    }
}

function disable_camera {
    scoreboard players set cut_feed ak.state 1
    scoreboard players set cut_feed_timer ak.state 100
    scoreboard players operation cut_camera ak.state = selected_camera office_info
    execute at @a run summon text_display ~ ~ ~ {Tags:["cut_feed"],text:'{"text":"C","font":"cursor"}'}
}

function set_video_camera_state_internal {
    function util:reset_camera_state
    ride @s dismount
    time set day

    execute if score vid_camera ak.state matches 0.. run tag @s add static
    execute if score vid_camera ak.state matches ..-1 run tag @s remove static
    execute if score vid_camera ak.state matches ..-1 run title @s actionbar ""

    # Cam 1a
    execute if score vid_camera ak.state matches 0 run ride @s mount @e[type=item_display,tag=cam_1a,limit=1]
    execute positioned as @e[type=item_display,tag=cam_1a,limit=1] if score vid_camera ak.state matches 0 run fillbiome ~-10 -64 ~-10 ~10 ~10 ~10 cam:1a
    execute positioned as @e[type=item_display,tag=cam_1a,limit=1] if score vid_camera ak.state matches 0 run fillbiome ~-10 ~10 ~-10 ~10 ~20 ~10 cam:1a

    # Cam 1b
    execute if score vid_camera ak.state matches 1 run ride @s mount @e[type=item_display,tag=cam_1b,limit=1]
    execute positioned as @e[type=item_display,tag=cam_1b,limit=1] if score vid_camera ak.state matches 1 run fillbiome ~-10 -64 ~-10 ~10 ~10 ~10 cam:1b
    execute positioned as @e[type=item_display,tag=cam_1b,limit=1] if score vid_camera ak.state matches 1 run fillbiome ~-10 ~10 ~-10 ~10 ~20 ~10 cam:1b

    # Cam 1c
    execute if score vid_camera ak.state matches 2 run ride @s mount @e[type=item_display,tag=cam_1c,limit=1]
    execute positioned as @e[type=item_display,tag=cam_1c,limit=1] if score vid_camera ak.state matches 2 run fillbiome ~-10 -64 ~-10 ~10 ~10 ~10 cam:1c
    execute positioned as @e[type=item_display,tag=cam_1c,limit=1] if score vid_camera ak.state matches 2 run fillbiome ~-10 ~10 ~-10 ~10 ~20 ~10 cam:1c

    # Cam 2a
    execute if score vid_camera ak.state matches 3 run ride @s mount @e[type=item_display,tag=cam_2a,limit=1]
    execute positioned as @e[type=item_display,tag=cam_2a,limit=1] if score vid_camera ak.state matches 3 run fillbiome ~-10 -64 ~-10 ~10 ~10 ~10 cam:2a
    execute positioned as @e[type=item_display,tag=cam_2a,limit=1] if score vid_camera ak.state matches 3 run fillbiome ~-10 ~10 ~-10 ~10 ~20 ~10 cam:2a
    
    # Cam 2b
    execute if score vid_camera ak.state matches 4 run ride @s mount @e[type=item_display,tag=cam_2b,limit=1]
    execute positioned as @e[type=item_display,tag=cam_2b,limit=1] if score vid_camera ak.state matches 4 run fillbiome ~-10 -64 ~-10 ~10 ~10 ~10 cam:2b
    execute positioned as @e[type=item_display,tag=cam_2b,limit=1] if score vid_camera ak.state matches 4 run fillbiome ~-10 ~10 ~-10 ~10 ~20 ~10 cam:2b

    # Cam 3
    execute if score vid_camera ak.state matches 5 run ride @s mount @e[type=item_display,tag=cam_3,limit=1]
    execute positioned as @e[type=item_display,tag=cam_3,limit=1] if score vid_camera ak.state matches 5 run fillbiome ~-10 -64 ~-10 ~10 ~10 ~10 cam:3
    execute positioned as @e[type=item_display,tag=cam_3,limit=1] if score vid_camera ak.state matches 5 run fillbiome ~-10 ~10 ~-10 ~10 ~20 ~10 cam:3

    # Cam 4a
    execute if score vid_camera ak.state matches 6 run ride @s mount @e[type=item_display,tag=cam_4a,limit=1]
    execute positioned as @e[type=item_display,tag=cam_4a,limit=1] if score vid_camera ak.state matches 6 run fillbiome ~-10 -64 ~-10 ~10 ~10 ~10 cam:4a
    execute positioned as @e[type=item_display,tag=cam_4a,limit=1] if score vid_camera ak.state matches 6 run fillbiome ~-10 ~10 ~-10 ~10 ~20 ~10 cam:4a

    # Cam 4b
    execute if score vid_camera ak.state matches 7 run ride @s mount @e[type=item_display,tag=cam_4b,limit=1]
    execute positioned as @e[type=item_display,tag=cam_4b,limit=1] if score vid_camera ak.state matches 7 run fillbiome ~-10 -64 ~-10 ~10 ~10 ~10 cam:4b
    execute positioned as @e[type=item_display,tag=cam_4b,limit=1] if score vid_camera ak.state matches 7 run fillbiome ~-10 ~10 ~-10 ~10 ~20 ~10 cam:4b

    # Cam 5
    execute if score vid_camera ak.state matches 8 run ride @s mount @e[type=item_display,tag=cam_5,limit=1]
    execute positioned as @e[type=item_display,tag=cam_5,limit=1] if score vid_camera ak.state matches 8 run fillbiome ~-10 -64 ~-10 ~10 ~10 ~10 cam:5
    execute positioned as @e[type=item_display,tag=cam_5,limit=1] if score vid_camera ak.state matches 8 run fillbiome ~-10 ~10 ~-10 ~10 ~20 ~10 cam:5

    # Disabled Cam 6
    execute if score vid_camera ak.state matches 100 run ride @s mount @e[type=item_display,tag=cam_6,limit=1]


    # Cam 7
    execute if score vid_camera ak.state matches 9 run ride @s mount @e[type=item_display,tag=cam_7,limit=1]
    execute positioned as @e[type=item_display,tag=cam_7,limit=1] if score vid_camera ak.state matches 9 run fillbiome ~-10 -64 ~-10 ~10 ~10 ~10 cam:7
    execute positioned as @e[type=item_display,tag=cam_7,limit=1] if score vid_camera ak.state matches 9 run fillbiome ~-10 ~10 ~-10 ~10 ~20 ~10 cam:7

    # Office camera
    execute if score vid_camera ak.state matches -1 run function util:office_camera_on_internal
}

function show_6am {
    execute at @a run playsound entity.horse.death master @a
    title @a times 40t 80t 40t
    title @a subtitle {"text":"B","font":"cursor"}
    sequence {
        title @a title ["",{"text":"\uEF00","font":"6am"},{"text":" AM","bold":true}]
        title @a subtitle {"text":"B","font":"cursor"}
        delay 2s
        title @a times 0t 10t 20t
        LOOP(72,i) {
            title @a title ["",{"text":"\uEF<%i.toLocaleString('en-US',{minimumIntegerDigits:2,useGrouping:false})%>","font":"6am"},{"text":" AM","bold":true}]
            title @a subtitle {"text":"B","font":"cursor"}
            delay 1t
        }
        LOOP(120,i) {
            title @a title ["",{"text":"\uEF71","font":"6am"},{"text":" AM","bold":true}]
            title @a subtitle {"text":"B","font":"cursor"}
            delay 1t 
        }
        delay 2s
        title @a times 10t 70t 20t
    }
}

function set_office_camera_state {

    LOOP(20,i) {
        execute if score camera_angle ak.state matches <%(i * 225) - 112%>..<%((i+1) * 225) - 113%> run fillbiome ~-10 -64 ~-10 ~10 ~10 ~10 office:<%i * 2.25%>_degrees
        execute if score camera_angle ak.state matches <%(i * 225) - 112%>..<%((i+1) * 225) - 113%> run fillbiome ~-10 ~10 ~-10 ~10 ~20 ~10 office:<%i * 2.25%>_degrees
    }
    execute if score camera_angle ak.state matches <%(20 * 225) - 112%>.. run fillbiome ~-10 -64 ~-10 ~10 ~10 ~10 office:<%20 * 2.25%>_degrees
    execute if score camera_angle ak.state matches <%(20 * 225) - 112%>.. run fillbiome ~-10 ~10 ~-10 ~10 ~20 ~10 office:<%20 * 2.25%>_degrees

    LOOP(19,i) {
        execute if score camera_angle ak.state matches -<%((i+2) * 225) - 113%>..-<%((i+1) * 225) - 112%> run fillbiome ~-10 -64 ~-10 ~10 ~10 ~10 office:-<%(i + 1)* 2.25%>_degrees
        execute if score camera_angle ak.state matches -<%((i+2) * 225) - 113%>..-<%((i+1) * 225) - 112%> run fillbiome ~-10 ~10 ~-10 ~10 ~20 ~10 office:-<%(i + 1)* 2.25%>_degrees
    }
    execute if score camera_angle ak.state matches ..-<%((19+1) * 225) - 112%> run fillbiome ~-10 -64 ~-10 ~10 ~10 ~10 office:-<%(19 + 1)* 2.25%>_degrees
    execute if score camera_angle ak.state matches ..-<%((19+1) * 225) - 112%> run fillbiome ~-10 ~10 ~-10 ~10 ~20 ~10 office:-<%(19 + 1)* 2.25%>_degrees

    execute if score camera_angle ak.state matches -1 run fillbiome ~-10 -64 ~-10 ~10 ~10 ~10 minecraft:plains
    execute if score camera_angle ak.state matches -1 run fillbiome ~-10 ~10 ~-10 ~10 ~20 ~10 minecraft:plains
}

function reset_camera_state {
    fillbiome ~-10 -64 ~-10 ~10 ~10 ~10 minecraft:plains
    fillbiome ~-10 ~10 ~-10 ~10 ~20 ~10 minecraft:plains
}

function reset_office_camera_state {
    scoreboard players set camera_angle ak.state -1
    function util:set_office_camera_state
}

function office_camera_on_internal {
    function util:reset_video_camera
    time set day
    tag @s add active_office_camera
    tp @s -23.5 -59.5 193.3 0.0 0.0
    scoreboard players set camera_angle ak.state 0
    ride @s mount @e[type=item_display,tag=office_mount,limit=1]
}

function office_camera_off_internal {
    time set midnight
    tag @s remove active_office_camera
    title @s actionbar ""
    function util:reset_office_camera_state
    ride @s dismount 
}


function setup_office_camera {
    tag @s add cursor
    sequence {
        execute unless score manual_shader ak.state matches 1 as @p at @s run function util:trigger_shader
        delay 3t
        execute as @p at @s run function util:office_camera_on_internal
    }
}

function reset_office_camera {
    tag @s remove cursor
    function util:office_camera_off_internal
}